# NoWakeLock 应用 UI 现状分析文档

## 应用概述

NoWakeLock 是一个 Android 应用，旨在监控和管理设备上的唤醒锁（Wakelocks）、闹钟（Alarms）和服务（Services），以优化电池使用。应用目前使用 Material Design 1 设计语言，并采用传统的 XML 布局和 DataBinding 进行开发。

## 现有 UI 结构

### 1. 导航结构

当前应用使用抽屉式导航（Navigation Drawer）作为主要导航方式，包含以下主要部分：

- 应用列表（Apps）
- 唤醒锁列表（Wakelocks）
- 闹钟列表（Alarms）
- 服务列表（Services）
- 设置（Settings）

### 2. 主要页面

#### 应用列表页面 (app_detail.html)
- 显示所有安装的应用及其唤醒锁状态
- 包含应用图标、名称、包名
- 显示每个应用的唤醒锁、闹钟和服务统计信息
- 提供过滤和排序选项
- 顶部应用栏包含标题和搜索/菜单按钮

#### 应用详情页面 (app_detail.html)
- 显示特定应用的详细信息
- 包含应用图标、名称、包名和状态
- 统计摘要部分显示唤醒锁、闹钟、服务数量和总时间
- 提供标签页导航（App、Wakelocks、Alarms、Services）
- 包含应用设置，如允许唤醒锁和时间间隔的开关
- 提供唤醒锁和闹钟的阻止模式设置

#### 唤醒锁列表页面 (wakelock.html)
- 显示所有应用的唤醒锁
- 包含过滤选项（全部、已阻止、已允许）
- 提供排序选项（按名称、计数、时间）
- 显示唤醒锁统计摘要（总数、阻止百分比、允许百分比）
- 列出各个唤醒锁，包括名称、关联应用、状态、节省时间和计数

#### 唤醒锁详情页面 (wakelock_detail.html)
- 显示特定唤醒锁的详细信息
- 包含唤醒锁名称和关联应用
- 统计摘要显示激活次数、阻止次数、总时间和节省时间
- 提供唤醒锁设置，如阻止唤醒锁和睡眠时阻止的开关
- 显示过去 24 小时的活动时间线图表
- 列出最近的活动记录，包括时间戳和持续时间

#### 闹钟列表页面 (alarm.html)
- 显示所有应用的闹钟
- 包含过滤选项（全部、已阻止、已允许）
- 提供排序选项（按名称、计数、时间）
- 显示闹钟统计摘要（总数、阻止百分比、允许百分比）
- 列出各个闹钟，包括名称、关联应用、状态、节省时间和计数

#### 闹钟详情页面 (alarm_detail.html)
- 显示特定闹钟的详细信息
- 包含闹钟名称和关联应用
- 统计摘要显示激活次数、阻止次数、总时间和节省时间
- 提供闹钟设置，如阻止闹钟和睡眠时阻止的开关
- 显示触发模式信息（间隔模式和最活跃的触发时间）
- 显示过去 24 小时的活动时间线图表
- 列出最近的活动记录，包括时间戳和描述

#### 服务列表页面 (service.html)
- 显示所有应用的服务
- 包含过滤选项（全部、已阻止、已允许）
- 提供排序选项（按名称、计数、时间）
- 显示服务统计摘要（总数、阻止百分比、允许百分比）
- 列出各个服务，包括名称、关联应用、状态、节省时间和计数

#### 服务详情页面 (service_detail.html)
- 显示特定服务的详细信息
- 包含服务名称和关联应用
- 统计摘要显示激活次数、阻止次数、总时间和节省时间
- 提供服务设置，如阻止服务和睡眠时阻止的开关
- 显示服务信息（服务类型、启动类型、进程）
- 显示过去 24 小时的活动时间线图表
- 列出最近的活动记录，包括时间戳和描述

#### 设置页面 (settings.html)
- 提供应用的全局设置选项
- 分为多个类别：
  - 常规设置（记录数据、数据同步等）
  - 主题设置（应用主题、深色模式）
  - 数据管理（充电后重置计数、清除非活动记录）
  - 备份和恢复（创建和恢复设置备份）
  - 高级设置（调试模式、应用版本信息）

### 3. UI 组件和样式

#### 常用组件
- 顶部应用栏（带标题和操作按钮）
- 卡片布局（用于显示信息组）
- 列表项（用于显示应用、唤醒锁等）
- 开关（用于启用/禁用功能）
- 标签页（用于在详情页面中导航）
- 过滤芯片（用于过滤列表内容）
- 统计卡片（显示数据摘要）
- 图表（显示活动时间线）
- 底部导航栏（在新设计中替代抽屉式导航）

#### 颜色方案
- 主要使用紫色调作为主色
- 使用绿色表示"允许"状态
- 使用红色表示"阻止"状态
- 使用浅灰色背景和白色卡片

#### 排版
- 使用层次分明的标题和正文文本
- 使用小号文本显示次要信息
- 使用中等大小文本显示统计数据

### 4. 交互模式

- 点击列表项导航到详情页面
- 使用开关切换状态（阻止/允许）
- 使用标签页在详情页面中切换不同视图
- 使用过滤芯片筛选列表内容
- 使用底部导航栏在主要页面之间切换
- 使用返回按钮从详情页面返回列表页面

## 技术实现

当前应用使用：
- 传统的 XML 布局
- Material Design 1 组件
- DataBinding 进行数据绑定
- 可能使用 Fragment 和 Activity 进行导航

## 设计语言迁移目标

计划从 Material Design 1 迁移到 Material Design 3，主要变化包括：
- 更现代的视觉设计（圆角、动态颜色等）
- 更一致的组件库
- 改进的交互模式
- 支持深色模式
- 更好的可访问性

同时，计划从传统 XML 布局迁移到 Jetpack Compose，以简化 UI 开发并提高代码质量。
